﻿namespace Microsoft.Samples.PlanMyNight.AddIns.EmailItinerary.Notifications
{
    using System.Globalization;
    using System.Resources;

    public class ResourceTemplateReader : ITemplateReader
    {
        private readonly ResourceManager resourceManager;

        public ResourceTemplateReader(ResourceManager resourceManager)
        {
            this.resourceManager = resourceManager;
        }

        public string RetrieveTemplate(string templateName)
        {
            return this.resourceManager.GetString(templateName, CultureInfo.InvariantCulture);
        }
    }
}